(() => {
    const body = document.getElementById('itemsBody');
    const addRow = document.getElementById('addRow');
    if (!body || !addRow) return;

    function wire(row) {
        row.querySelectorAll('.remove-row').forEach((btn) => {
            btn.addEventListener('click', () => {
                const rows = body.querySelectorAll('.item-row');
                if (rows.length <= 1) return;
                row.remove();
            });
        });
    }

    addRow.addEventListener('click', () => {
        const tpl = body.querySelector('.item-row');
        if (!tpl) return;
        const clone = tpl.cloneNode(true);
        clone.querySelectorAll('input, select').forEach((el) => {
            if (el.name === 'set_no[]') el.value = '1';
            if (el.name === 'position[]') el.value = '';
            if (el.name === 'season[]') el.value = 'winter';
            if (el.name === 'tire_size[]') el.value = '';
            if (el.name === 'brand[]') el.value = '';
            if (el.name === 'model[]') el.value = '';
            if (el.name === 'dot[]') el.value = '';
            if (el.name === 'tread_mm[]') el.value = '';
            if (el.name === 'item_location[]') el.value = '';
            if (el.name === 'rim_size[]') el.value = '';
            if (el.name === 'item_notes[]') el.value = '';
            if (el.name === 'has_rims[]') {
                if (el.type === 'checkbox') el.checked = false;
                if (el.type === 'hidden') el.value = '0';
            }
        });
        body.appendChild(clone);
        wire(clone);
    });

    body.querySelectorAll('.item-row').forEach(wire);
})();

