(() => {
    const tabButtons = Array.from(document.querySelectorAll('[data-settings-tab]'));
    const body = document.getElementById('settingsTabBody');
    if (!body || tabButtons.length === 0) return;

    const base = body.getAttribute('data-tab-base') || '';
    if (!base) return;

    function setActive(tab) {
        tabButtons.forEach((b) => b.classList.toggle('active', b.getAttribute('data-settings-tab') === tab));
        if (history.replaceState) {
            const url = new URL(window.location.href);
            url.hash = tab;
            history.replaceState(null, '', url.toString());
        }
    }

    async function loadTab(tab) {
        setActive(tab);
        body.innerHTML = '<div class="text-secondary">Ielādē...</div>';

        const res = await fetch(`${base}/${encodeURIComponent(tab)}`, {
            headers: { 'X-Requested-With': 'fetch' },
            credentials: 'same-origin',
        });
        body.innerHTML = await res.text();
    }

    document.addEventListener('click', (e) => {
        const btn = e.target.closest('[data-settings-tab]');
        if (!btn) return;
        e.preventDefault();
        const tab = btn.getAttribute('data-settings-tab');
        if (tab) loadTab(tab).catch(() => (body.innerHTML = '<div class="alert alert-danger">Neizdevās ielādēt.</div>'));
    });

    document.addEventListener('submit', async (e) => {
        const form = e.target;
        if (!(form instanceof HTMLFormElement)) return;
        if (!form.matches('form[data-ajax-form="1"]')) return;

        e.preventDefault();
        window.Serviss?.clearFormErrors?.(form);

        const action = form.getAttribute('action') || window.location.href;
        const method = (form.getAttribute('method') || 'post').toUpperCase();
        const submitBtn = form.querySelector('button[type="submit"]');
        if (submitBtn) submitBtn.disabled = true;

        try {
            const res = await fetch(action, {
                method,
                body: new FormData(form),
                headers: { 'X-Requested-With': 'fetch' },
                credentials: 'same-origin',
            });

            const json = await res.json();
            window.Serviss?.updateCsrf?.(json?.csrfToken, json?.csrfHash);

            if (!res.ok) {
                window.Serviss?.showFormErrors?.(form, json?.errors || {});
                if (json?.message) window.Serviss?.flash?.(body, json.message, 'danger');
                return;
            }

            if (json?.html) {
                body.innerHTML = json.html;
            }

            if (json?.message) {
                window.Serviss?.flash?.(body, json.message, 'success');
            }

            if (json?.applyTheme) {
                window.Serviss?.applyTheme?.(json.applyTheme);
            }

            if (json?.brandName !== undefined || json?.brandLogoUrl !== undefined) {
                window.Serviss?.updateBrand?.(json?.brandName || '', json?.brandLogoUrl || '');
            }

            if (json?.reloadNav) {
                window.setTimeout(() => window.location.reload(), 600);
            }
        } catch {
            window.Serviss?.flash?.(body, 'Neizdevās saglabāt. Mēģini vēlreiz.', 'danger');
        } finally {
            if (submitBtn) submitBtn.disabled = false;
        }
    });

    const initial = (window.location.hash || '#company').replace('#', '') || 'company';
    loadTab(initial).catch(() => (body.innerHTML = '<div class="alert alert-danger">Neizdevās ielādēt.</div>'));
})();

