(() => {
    const sel = document.getElementById('client_type');
    const company = document.getElementById('clientCompanyFields');
    const companyReg = document.getElementById('clientCompanyRegistrationNo');
    const companyVat = document.getElementById('clientCompanyVatNo');
    const companyContact = document.getElementById('clientCompanyContactPerson');
    const personFirst = document.getElementById('clientPersonFirstName');
    const personLast = document.getElementById('clientPersonLastName');
    const personCode = document.getElementById('clientPersonPersonalCode');
    if (!sel) return;

    function sync() {
        const type = sel.value || 'person';
        const isPerson = type === 'person';
        if (company) company.classList.toggle('d-none', isPerson);
        if (companyReg) companyReg.classList.toggle('d-none', isPerson);
        if (companyVat) companyVat.classList.toggle('d-none', isPerson);
        if (companyContact) companyContact.classList.toggle('d-none', isPerson);
        if (personFirst) personFirst.classList.toggle('d-none', !isPerson);
        if (personLast) personLast.classList.toggle('d-none', !isPerson);
        if (personCode) personCode.classList.toggle('d-none', !isPerson);
    }

    sel.addEventListener('change', sync);
    sync();

    const setVal = (id, value) => {
        const el = document.getElementById(id);
        if (!el) return;
        if ('value' in el) el.value = value == null ? '' : String(value);
    };

    const lockClientFields = (locked) => {
        [
            'client_type',
            'client_company_name',
            'client_first_name',
            'client_last_name',
            'client_personal_code',
            'client_registration_no',
            'client_vat_no',
            'client_phone',
            'client_contact_person',
            'client_email',
            'client_address',
            'client_notes',
        ].forEach((id) => {
            const el = document.getElementById(id);
            if (!el) return;
            el.disabled = !!locked;
        });
    };

    const lockVehicleFields = (locked) => {
        [
            'vehicle_plate_no',
            'vehicle_make',
            'vehicle_model',
            'vehicle_year',
            'vehicle_vin',
            'vehicle_notes',
        ].forEach((id) => {
            const el = document.getElementById(id);
            if (!el) return;
            el.disabled = !!locked;
        });
    };

    const clientLookup = document.getElementById('intake_client_lookup');
    const clientIdEl = document.getElementById('intake_client_id');
    const vehicleLookup = document.getElementById('intake_vehicle_lookup');
    const vehicleIdEl = document.getElementById('intake_vehicle_id');

    const applyClientMeta = (meta, lock = false) => {
        if (!meta) return;
        const t = String(meta.type || 'company').toLowerCase() === 'person' ? 'person' : 'company';
        setVal('client_type', t);
        setVal('client_company_name', meta.company_name || meta.name || '');
        setVal('client_first_name', meta.first_name || '');
        setVal('client_last_name', meta.last_name || '');
        setVal('client_personal_code', meta.personal_code || '');
        setVal('client_registration_no', meta.registration_no || '');
        setVal('client_vat_no', meta.vat_no || '');
        setVal('client_phone', meta.phone || '');
        setVal('client_contact_person', meta.contact_person || '');
        setVal('client_email', meta.email || '');
        setVal('client_address', meta.address || '');
        setVal('client_notes', meta.notes || '');
        sync();
        lockClientFields(lock);
    };

    const applyVehicleMeta = (meta, lock = false) => {
        if (!meta) return;
        setVal('vehicle_plate_no', meta.plate_no || '');
        setVal('vehicle_make', meta.make || '');
        setVal('vehicle_model', meta.model || '');
        setVal('vehicle_year', meta.year || '');
        setVal('vehicle_vin', meta.vin || '');
        setVal('vehicle_notes', meta.notes || '');
        lockVehicleFields(lock);
    };

    // Client lookup -> fill client fields (read-only by default)
    clientLookup?.addEventListener('lookup:selected', (e) => {
        const row = e.detail || {};
        const meta = row.meta || {};
        applyClientMeta(meta, true);
    });
    clientLookup?.addEventListener('lookup:cleared', () => {
        if (clientIdEl) clientIdEl.value = '';
        lockClientFields(false);
    });

    // Vehicle lookup -> fill vehicle + client fields (read-only by default)
    vehicleLookup?.addEventListener('lookup:selected', (e) => {
        const row = e.detail || {};
        const meta = row.meta || {};
        applyVehicleMeta(meta, true);

        // Also select the vehicle's client (if provided)
        const client = meta.client || null;
        const cid = Number(meta.client_id || client?.id || 0) || 0;
        if (clientIdEl) clientIdEl.value = cid ? String(cid) : '';
        if (client) {
            applyClientMeta(client, true);
        }
        // Keep the client lookup input in sync (best-effort)
        if (clientLookup && client?.name) {
            clientLookup.value = String(client.name);
        }
    });
    vehicleLookup?.addEventListener('lookup:cleared', () => {
        if (vehicleIdEl) vehicleIdEl.value = '';
        lockVehicleFields(false);
    });
})();

