(() => {
    const body = document.getElementById('itemsBody');
    const addRow = document.getElementById('addRow');
    const grandTotal = document.getElementById('grandTotal');
    if (!body || !addRow || !grandTotal) return;

    const parseNum = (v) => {
        const n = parseFloat(String(v || '').replace(',', '.'));
        return Number.isFinite(n) ? n : 0;
    };

    function recalc() {
        let total = 0;
        body.querySelectorAll('.item-row').forEach((row) => {
            const qty = parseNum(row.querySelector('input[name="qty[]"]')?.value);
            const cost = parseNum(row.querySelector('input[name="unit_cost[]"]')?.value);
            const line = Math.round(qty * cost * 100) / 100;
            total += line;
            const el = row.querySelector('.line-total');
            if (el) el.textContent = line.toFixed(2);
        });
        grandTotal.textContent = (Math.round(total * 100) / 100).toFixed(2);
    }

    function wireRow(row) {
        row.addEventListener('input', recalc);

        row.querySelectorAll('input[data-lookup="products"]').forEach((input) => {
            input.addEventListener('lookup:selected', (e) => {
                const cost = e.detail?.meta?.cost;
                const costInput = row.querySelector('input[name="unit_cost[]"]');
                if (costInput && (costInput.value === '' || costInput.value === '0') && cost !== null && cost !== undefined) {
                    costInput.value = String(cost);
                }
                recalc();
            });
        });

        row.querySelectorAll('.remove-row').forEach((btn) => {
            btn.addEventListener('click', () => {
                const rows = body.querySelectorAll('.item-row');
                if (rows.length <= 1) return;
                row.remove();
                recalc();
            });
        });
    }

    addRow.addEventListener('click', () => {
        const tpl = body.querySelector('.item-row');
        if (!tpl) return;
        const clone = tpl.cloneNode(true);
        clone.querySelectorAll('input').forEach((el) => {
            if (el.name === 'product_id[]') el.value = '';
            if (el.name === 'product_label[]') el.value = '';
            if (el.name === 'qty[]') el.value = '1';
            if (el.name === 'unit_cost[]') el.value = '0';
        });
        body.appendChild(clone);
        window.Serviss?.initLookups?.(clone);
        wireRow(clone);
        recalc();
    });

    body.querySelectorAll('.item-row').forEach(wireRow);
    recalc();
})();

