(() => {
    const S = (window.Serviss = window.Serviss || {});

    function getTheme() {
        return document.documentElement.getAttribute('data-bs-theme') || 'light';
    }

    function setTheme(theme) {
        const next = theme === 'dark' ? 'dark' : 'light';
        document.documentElement.setAttribute('data-bs-theme', next);
        try {
            localStorage.setItem('theme', next);
        } catch {
            // ignore
        }
        try {
            document.dispatchEvent(new CustomEvent('serviss:theme', { detail: { theme: next } }));
        } catch {
            // ignore
        }
        return next;
    }

    function initThemeToggle() {
        const btn = document.getElementById('themeToggle');
        if (!btn) return;

        const iconHost = btn.querySelector('span');
        const syncIcon = (theme) => {
            if (!iconHost) return;
            iconHost.className = theme === 'dark' ? 'fa-solid fa-moon' : 'fa-solid fa-sun';
        };

        syncIcon(getTheme());

        btn.addEventListener('click', () => {
            const next = getTheme() === 'dark' ? 'light' : 'dark';
            syncIcon(setTheme(next));
        });
    }

    function initPasswordToggles() {
        // Event delegation so it also works for drawer-loaded forms.
        document.addEventListener('click', (e) => {
            const btn = e.target.closest('[data-password-toggle="1"], #togglePw');
            if (!btn) return;

            const group = btn.closest('.input-group');
            const scope = btn.closest('form') || document;

            /** @type {HTMLInputElement|null} */
            let input = null;
            if (group) {
                const el = group.querySelector('input[type="password"], input[type="text"]');
                if (el instanceof HTMLInputElement) input = el;
            }

            if (!input) {
                const target = btn.getAttribute('data-password-target');
                if (target) {
                    const el = (scope.querySelector(target) || document.querySelector(target));
                    if (el instanceof HTMLInputElement) input = el;
                } else if (btn.id === 'togglePw') {
                    const el = scope.querySelector('#password') || document.getElementById('password');
                    if (el instanceof HTMLInputElement) input = el;
                }
            }

            if (!input) return;
            const type = input.getAttribute('type') || 'password';
            if (type !== 'password' && type !== 'text') return;

            e.preventDefault();

            const isPw = type === 'password';
            input.setAttribute('type', isPw ? 'text' : 'password');
            btn.setAttribute('aria-pressed', isPw ? 'true' : 'false');

            const icon = btn.querySelector('i');
            if (icon) icon.className = isPw ? 'fa-solid fa-eye-slash' : 'fa-solid fa-eye';
        });
    }

    function initEmployeeSalaryToggle() {
        const sel = document.getElementById('salary_type');
        const hourlyWrap = document.getElementById('hourly_rate_wrap');
        const monthlyWrap = document.getElementById('monthly_salary_wrap');
        const percentWrap = document.getElementById('percent_rate_wrap');
        if (!sel || !hourlyWrap || !monthlyWrap || !percentWrap) return;

        function sync() {
            const type = (sel.value || 'hourly');
            hourlyWrap.classList.toggle('d-none', type !== 'hourly');
            monthlyWrap.classList.toggle('d-none', type !== 'monthly');
            percentWrap.classList.toggle('d-none', type !== 'percent');
        }

        sel.addEventListener('change', sync);
        sync();
    }

    function initDatePickers(root = document) {
        if (typeof window.flatpickr !== 'function') return;

        const meta = document.querySelector('meta[name="serviss-date-format"]');
        const fmtRaw = meta ? String(meta.getAttribute('content') || '').trim() : '';
        const allowed = ['d.m.Y', 'd/m/Y', 'd-m-Y', 'Y-m-d', 'Y.m.d', 'm/d/Y'];
        const fmt = allowed.includes(fmtRaw) ? fmtRaw : 'd.m.Y';

        const lang = String(document.documentElement.getAttribute('lang') || '').toLowerCase();
        const locale = lang.startsWith('lv') && window.flatpickr.l10ns?.lv ? window.flatpickr.l10ns.lv : undefined;

        const inputs = root.querySelectorAll('input[type="date"], input[data-datepicker="1"]');
        inputs.forEach((input) => {
            if (!(input instanceof HTMLInputElement)) return;
            if (input.dataset.datepickerReady === '1') return;
            if (input.disabled || input.readOnly) return;

            input.dataset.datepickerReady = '1';

            const min = String(input.getAttribute('min') || '').trim();
            const max = String(input.getAttribute('max') || '').trim();

            try {
                window.flatpickr(input, {
                    dateFormat: 'Y-m-d',     // value posted to backend
                    altInput: true,          // display uses settings format
                    altFormat: fmt,
                    altInputClass: input.className || 'form-control',
                    allowInput: true,
                    disableMobile: true,
                    locale,
                    minDate: min || undefined,
                    maxDate: max || undefined,
                });
            } catch {
                // ignore
            }
        });
    }

    function initWorkOrderStatusAutoCloseDate() {
        const todayYmd = () => {
            const d = new Date();
            const yyyy = d.getFullYear();
            const mm = String(d.getMonth() + 1).padStart(2, '0');
            const dd = String(d.getDate()).padStart(2, '0');
            return `${yyyy}-${mm}-${dd}`;
        };

        // Event delegation so it also works for drawer-loaded work order forms.
        document.addEventListener('change', (e) => {
            const sel = e.target;
            if (!(sel instanceof HTMLSelectElement)) return;
            if (sel.name !== 'status' && sel.id !== 'status') return;

            const scope = sel.closest('form') || document;
            const closedAt = scope.querySelector('input[name="closed_at"], #closed_at');
            if (!(closedAt instanceof HTMLInputElement)) return; // not a work order form

            const status = String(sel.value || '').trim().toLowerCase();
            if (status !== 'closed' && status !== 'invoiced') return;

            if (String(closedAt.value || '').trim() !== '') return;

            const t = todayYmd();
            if (closedAt._flatpickr && typeof closedAt._flatpickr.setDate === 'function') {
                closedAt._flatpickr.setDate(t, true);
                return;
            }

            closedAt.value = t;
            try { closedAt.dispatchEvent(new Event('change', { bubbles: true })); } catch { /* ignore */ }
        });
    }

    function initWorkOrderInvoiceWarnings() {
        const readMechanicId = (form) => {
            const local = form.querySelector?.('#assigned_user_id, [name="assigned_user_id"]') || null;
            const el = local || document.getElementById('assigned_user_id');
            if (el instanceof HTMLSelectElement || el instanceof HTMLInputElement) {
                return String(el.value || '').trim();
            }
            return '';
        };

        const getPathname = (action) => {
            try {
                return new URL(String(action || ''), window.location.origin).pathname || '';
            } catch {
                return String(action || '');
            }
        };

        document.addEventListener('submit', (e) => {
            const form = e.target;
            if (!(form instanceof HTMLFormElement)) return;
            if (e.defaultPrevented) return;

            const submitter = e.submitter instanceof HTMLElement ? e.submitter : null;
            const action =
                (submitter && submitter.getAttribute('formaction')) ||
                form.getAttribute('action') ||
                window.location.href;
            const path = getPathname(action);

            // Creating an invoice from a work order (button "Izrakstīt rēķinu").
            if (path.includes('/work-orders/') && path.endsWith('/invoice')) {
                if (readMechanicId(form) !== '') return;
                const ok = window.confirm('Meistars nav norādīts. Izrakstīt rēķinu bez meistara?');
                if (!ok) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                return;
            }

            // Saving a work order as "invoiced" without a mechanic.
            if (path.includes('/work-orders/')) {
                const statusSel = form.querySelector('select[name="status"], #status');
                if (!(statusSel instanceof HTMLSelectElement)) return;

                const status = String(statusSel.value || '').trim().toLowerCase();
                if (status !== 'invoiced') return;

                if (readMechanicId(form) !== '') return;
                const ok = window.confirm('Statuss “Rēķins izrakstīts” ir izvēlēts, bet meistars nav norādīts. Saglabāt tāpat?');
                if (!ok) {
                    e.preventDefault();
                    e.stopPropagation();
                }
            }
        });
    }

    function syncClientTypeScope(scope) {
        const typeSel = scope.querySelector('[data-client-type-toggle="1"]');
        if (!(typeSel instanceof HTMLSelectElement)) return;

        const nodes = Array.from(scope.querySelectorAll('[data-client-type]'));
        const apply = () => {
            const t = typeSel.value || 'company';
            nodes.forEach((el) => {
                const match = el.getAttribute('data-client-type') === t;
                el.style.display = match ? '' : 'none';
            });
        };

        typeSel.addEventListener('change', apply);
        apply();
    }

    function initClientTypeToggles(root = document) {
        root.querySelectorAll('[data-client-type-scope="1"]').forEach((scope) => {
            syncClientTypeScope(scope);
        });
    }

    function initAutoSubmit() {
        document.querySelectorAll('form[data-autosubmit="1"]').forEach((form) => {
            if (!(form instanceof HTMLFormElement)) return;
            form.addEventListener('change', (e) => {
                const el = e.target;
                if (!(el instanceof HTMLSelectElement || el instanceof HTMLInputElement)) return;
                if (typeof form.requestSubmit === 'function') {
                    form.requestSubmit();
                } else {
                    form.submit();
                }
            });
        });
    }

    function initPerPageSelects() {
        const selects = document.querySelectorAll('select[data-per-page="1"]');
        if (!selects.length) return;

        const hasOptionValue = (sel, value) => {
            const v = String(value || '').trim();
            if (!v) return false;
            return Array.from(sel.options || []).some((opt) => String(opt.value) === v);
        };

        const clearPagerParams = (params) => {
            // CI4 pager uses "page" and "page_{group}" query params.
            Array.from(params.keys()).forEach((k) => {
                if (k === 'page' || k.startsWith('page_')) params.delete(k);
            });
        };

        selects.forEach((sel) => {
            if (!(sel instanceof HTMLSelectElement)) return;

            const listKey = (sel.getAttribute('data-list-key') || window.location.pathname || 'list').replace(/[^a-z0-9_.-]/gi, '_');
            const storageKey = `serviss.perPage.${listKey}`;
            const url = new URL(window.location.href);
            const params = url.searchParams;

            const current = String(params.get('perPage') || '').trim();
            const fromSelect = String(sel.value || '').trim();

            // If URL has perPage, persist it.
            if (current !== '' && hasOptionValue(sel, current)) {
                try {
                    localStorage.setItem(storageKey, current);
                } catch {
                    // ignore
                }
                sel.value = current;
            } else {
                // If URL doesn't have perPage but localStorage does, apply it (once).
                let stored = '';
                try {
                    stored = String(localStorage.getItem(storageKey) || '').trim();
                } catch {
                    stored = '';
                }
                if (stored !== '' && hasOptionValue(sel, stored) && stored !== fromSelect) {
                    params.set('perPage', stored);
                    clearPagerParams(params);
                    window.location.search = params.toString();
                    return;
                }
            }

            sel.addEventListener('change', () => {
                const v = String(sel.value || '').trim();
                if (v) {
                    try {
                        localStorage.setItem(storageKey, v);
                    } catch {
                        // ignore
                    }
                }

                const form = sel.closest('form');
                if (form instanceof HTMLFormElement) {
                    if (typeof form.requestSubmit === 'function') {
                        form.requestSubmit();
                    } else {
                        form.submit();
                    }
                    return;
                }

                // Fallback: update URL and reload.
                const u = new URL(window.location.href);
                u.searchParams.set('perPage', v);
                clearPagerParams(u.searchParams);
                window.location.href = u.toString();
            });
        });
    }

    function initDrawer() {
        const drawerEl = document.getElementById('appDrawer');
        const bodyEl = document.getElementById('appDrawerBody');
        const titleEl = document.getElementById('appDrawerLabel');
        if (!drawerEl || !bodyEl || !titleEl) return;

        // Requires Bootstrap bundle (window.bootstrap)
        if (!window.bootstrap || !window.bootstrap.Offcanvas) return;

        const drawer = window.bootstrap.Offcanvas.getOrCreateInstance(drawerEl);

        async function loadDrawer(url, title = '—') {
            titleEl.textContent = title;
            bodyEl.innerHTML = '<div class="text-secondary">Ielādē...</div>';
            drawer.show();

            const res = await fetch(url, {
                headers: {
                    'X-Requested-With': 'fetch',
                },
                credentials: 'same-origin',
            });

            const html = await res.text();
            bodyEl.innerHTML = html;
            initClientTypeToggles(bodyEl);
            initDatePickers(bodyEl);
            S.initLookups?.(bodyEl);
            S.initCalendarForms?.(bodyEl);
            S.initClientVehiclePairs?.(bodyEl);
        }

        document.addEventListener('click', (e) => {
            const link = e.target.closest('[data-drawer-url]');
            if (!link) return;

            const url = link.getAttribute('data-drawer-url') || link.getAttribute('href');
            if (!url) return;

            e.preventDefault();
            const title = link.getAttribute('data-drawer-title') || link.textContent?.trim() || '—';
            loadDrawer(url, title).catch(() => {
                bodyEl.innerHTML = '<div class="alert alert-danger">Neizdevās ielādēt.</div>';
            });
        });

        document.addEventListener('submit', async (e) => {
            const form = e.target;
            if (!(form instanceof HTMLFormElement)) return;
            if (!form.matches('form[data-drawer-form="1"]')) return;
            if (e.defaultPrevented) return;

            e.preventDefault();
            S.clearFormErrors?.(form);

            const submitter = e.submitter instanceof HTMLElement ? e.submitter : null;
            const action =
                (submitter && submitter.getAttribute('formaction')) ||
                form.getAttribute('action') ||
                window.location.href;
            const method = (
                (submitter && submitter.getAttribute('formmethod')) ||
                form.getAttribute('method') ||
                'post'
            ).toUpperCase();
            const formData = new FormData(form);
            const submitBtn =
                submitter && submitter.matches?.('button[type="submit"],input[type="submit"]')
                    ? submitter
                    : form.querySelector('button[type="submit"],input[type="submit"]');
            if (submitBtn) submitBtn.disabled = true;

            try {
                const res = await fetch(action, {
                    method,
                    body: formData,
                    headers: { 'X-Requested-With': 'fetch' },
                    credentials: 'same-origin',
                });

                const contentType = res.headers.get('content-type') || '';
                if (contentType.includes('application/json')) {
                    const json = await res.json();
                    S.updateCsrf?.(json?.csrfToken, json?.csrfHash);

                    if (!res.ok) {
                        S.showFormErrors?.(form, json?.errors || {});
                        if (json?.message) {
                            S.flash?.(bodyEl, json.message, 'danger');
                        }
                        return;
                    }

                    if (json?.calendarRefresh) {
                        S.calendarRefresh?.();
                    }
                    if (json?.reload) {
                        window.location.reload();
                        return;
                    }
                    if (json?.redirect) {
                        window.location.href = json.redirect;
                        return;
                    }
                    if (json?.close) {
                        drawer.hide();
                    }
                    if (json?.message) {
                        S.flash?.(bodyEl, json.message, 'success');
                    }
                    return;
                }

                const html = await res.text();
                bodyEl.innerHTML = html;
                initClientTypeToggles(bodyEl);
                initDatePickers(bodyEl);
                S.initLookups?.(bodyEl);
                S.initCalendarForms?.(bodyEl);
                S.initClientVehiclePairs?.(bodyEl);
            } catch {
                bodyEl.innerHTML = '<div class="alert alert-danger">Neizdevās saglabāt.</div>';
            } finally {
                if (submitBtn) submitBtn.disabled = false;
            }
        });
    }

    function initAjaxForms() {
        document.addEventListener('submit', async (e) => {
            const form = e.target;
            if (!(form instanceof HTMLFormElement)) return;
            if (!form.matches('form[data-ajax="1"]')) return;
            if (e.defaultPrevented) return;

            e.preventDefault();
            S.clearFormErrors?.(form);

            const submitter = e.submitter instanceof HTMLElement ? e.submitter : null;
            const action =
                (submitter && submitter.getAttribute('formaction')) ||
                form.getAttribute('action') ||
                window.location.href;
            const method = (
                (submitter && submitter.getAttribute('formmethod')) ||
                form.getAttribute('method') ||
                'post'
            ).toUpperCase();
            const submitBtn =
                submitter && submitter.matches?.('button[type="submit"],input[type="submit"]')
                    ? submitter
                    : form.querySelector('button[type="submit"],input[type="submit"]');
            if (submitBtn) submitBtn.disabled = true;

            try {
                const res = await fetch(action, {
                    method,
                    body: new FormData(form),
                    headers: { 'X-Requested-With': 'fetch' },
                    credentials: 'same-origin',
                });

                const contentType = res.headers.get('content-type') || '';
                if (!contentType.includes('application/json')) {
                    const html = await res.text();
                    document.open();
                    document.write(html);
                    document.close();
                    return;
                }

                const json = await res.json();
                S.updateCsrf?.(json?.csrfToken, json?.csrfHash);

                if (!res.ok) {
                    S.showFormErrors?.(form, json?.errors || {});
                    if (json?.message) S.flash?.(form, json.message, 'danger');
                    return;
                }

                if (json?.calendarRefresh) {
                    S.calendarRefresh?.();
                }
                if (json?.reload) {
                    window.location.reload();
                    return;
                }
                if (json?.redirect) {
                    // If redirect points to the same page (often with #hash), force reload so UI updates.
                    try {
                        const target = new URL(String(json.redirect), window.location.origin);
                        const current = new URL(window.location.href);
                        if (target.pathname === current.pathname && target.search === current.search) {
                            if (target.hash && window.location.hash !== target.hash) {
                                window.location.hash = target.hash;
                            }
                            window.location.reload();
                            return;
                        }
                    } catch {
                        // ignore
                    }
                    window.location.href = json.redirect;
                    return;
                }

                if (json?.message) S.flash?.(form, json.message, 'success');
            } catch {
                S.flash?.(form, 'Neizdevās saglabāt. Mēģini vēlreiz.', 'danger');
            } finally {
                if (submitBtn) submitBtn.disabled = false;
            }
        });
    }

    document.addEventListener('DOMContentLoaded', () => {
        initThemeToggle();
        initPasswordToggles();
        initEmployeeSalaryToggle();
        initWorkOrderStatusAutoCloseDate();
        initWorkOrderInvoiceWarnings();
        initDatePickers(document);
        initClientTypeToggles(document);
        initAutoSubmit();
        initPerPageSelects();
        S.initLookups?.(document);
        S.initCalendarForms?.(document);
        S.initClientVehiclePairs?.(document);
        initAjaxForms();
        initDrawer();
    });
})();

