'use client';

import Link from 'next/link';
import { CircleCheck } from 'lucide-react';
import {
  Avatar,
  AvatarFallback,
  AvatarImage,
  AvatarIndicator,
  AvatarStatus,
} from '@/components/ui/avatar';
import { Button } from '@/components/ui/button';

export default function Item20() {
  return (
    <div className="flex grow gap-2.5 px-5">
      <Avatar>
        <AvatarImage src="/media/avatars/300-9.png" alt="avatar" />
        <AvatarFallback>CH</AvatarFallback>
        <AvatarIndicator className="-end-1.5 -bottom-1.5">
          <AvatarStatus variant="online" className="size-2.5" />
        </AvatarIndicator>
      </Avatar>

      <div className="flex flex-col gap-2.5 grow">
        <div className="flex flex-col gap-1 mb-1">
          <div className="text-sm font-medium mb-px">
            <Link
              href="#"
              className="hover:text-primary text-mono font-semibold"
            >
              Gabriel Bennett
            </Link>
            <span className="text-secondary-foreground">
              {' '}
              started connect you{' '}
            </span>
          </div>
          <span className="flex items-center text-xs font-medium text-muted-foreground">
            3 day ago
            <span className="rounded-full size-1 bg-mono/30 mx-1.5"></span>
            Development
          </span>
        </div>

        <div className="flex flex-wrap gap-2.5">
          <Button size="sm" variant="outline">
            <CircleCheck /> Connected
          </Button>
          <Button size="sm" variant="mono">
            Go to profile
          </Button>
        </div>
      </div>
    </div>
  );
}
