'use client';

import Link from 'next/link';
import { toAbsoluteUrl } from '@/lib/helpers';
import { Badge } from '@/components/ui/badge';
import { Card } from '@/components/ui/card';
import { Progress } from '@/components/ui/progress';
import { AvatarGroup } from '../common/avatar-group';

const CardProject = ({
  logo,
  name,
  description,
  startDate,
  endDate,
  status,
  progress,
  team,
}) => {
  return (
    <Card className="p-7.5">
      <div className="flex items-center justify-between mb-3 lg:mb-6">
        <div className="flex items-center justify-center size-[50px] rounded-lg bg-accent/60">
          <img
            src={toAbsoluteUrl(`/media/brand-logos/${logo}`)}
            className=""
            alt="image"
          />
        </div>
        <Badge size="lg" variant={status.variant} appearance="light">
          {status.label}
        </Badge>
      </div>
      <div className="flex flex-col mb-3 lg:mb-6">
        <Link
          href="#"
          className="text-lg font-media/brand text-mono hover:text-primary-active mb-px"
        >
          {name}
        </Link>
        <span className="text-sm text-secondary-foreground">{description}</span>
      </div>
      <div className="flex items-center gap-5 mb-3.5 lg:mb-7">
        <span className="text-sm text-secondary-foreground">
          Start:{' '}
          <span className="text-sm font-medium text-foreground">
            {startDate}
          </span>
        </span>
        <span className="text-sm text-secondary-foreground">
          End:{' '}
          <span className="text-sm font-medium text-foreground">{endDate}</span>
        </span>
      </div>
      <Progress
        value={progress?.value}
        indicatorClassName={progress?.variant}
        className="h-1.5 mb-4 lg:mb-8"
      />

      <AvatarGroup group={team.group} size={team.size} more={team.more} />
    </Card>
  );
};

export { CardProject };
