'use client';

import Link from 'next/link';
import { toAbsoluteUrl } from '@/lib/helpers';
import { Card } from '@/components/ui/card';

const CardLocation = ({ image, title, description }) => {
  return (
    <Card className="shadow-none w-[280px] border-0 mb-4">
      <img
        src={toAbsoluteUrl(`/media/images/600x400/${image}`)}
        className="rounded-t-xl max-w-[280px] shrink-0"
        alt="image"
      />

      <div className="card-border card-rounded-b px-3.5 h-full pt-3 pb-3.5">
        <Link
          href="#"
          className="font-medium block text-mono hover:text-primary text-base mb-2"
        >
          {title}
        </Link>
        <p className="text-sm text-secondary-foreground">{description}</p>
      </div>
    </Card>
  );
};

export { CardLocation };
